;LCD Routines


LCD_Delay:		;Load LCD_Delay_Val into r17:r16

				;loop cycles	= 4
				;non loop		= 4+2+4-1 = 16 (rcalled from LCD_Delay_XXXX)
				;delay (cycles)	= LCD_Delay_4100_Val*4 + 16
				;delay (cycles)	= delay (us) * (Osc_Freq / 1000000)
				;LCD_Delay_Val 	= ((delay (us) *(Osc_Freq/1000000))-16)/4)
				;				= ((delay (us) *(Osc_Freq/1000000))/4)-4)

				subi r16,1	;decrease counter by 1
				sbci r17,0
				
				brne LCD_Delay

				ret


LCD_Delay_4100:	ldi r16,low(LCD_Delay_4100_Val)
				ldi r17,high(LCD_Delay_4100_Val)

				rcall LCD_Delay
				ret


				
LCD_Delay_160:	ldi r16,low(LCD_Delay_160_Val)
				ldi r17,high(LCD_Delay_160_Val)

				rcall LCD_Delay
				ret

LCD_Delay_1:	nop
				ret					
	

LCD_Send_DH:	sbr r18,(1<<LCD_E)		;E=1
				andi r18,0x0F			;Data=0

				mov r17,r16
				andi r17,0xF0			;upper nibble

				or r18,r17				;r18=DH+Ctrl

				out LCD_Port,r18
				rcall LCD_Delay_1
				cbr r18,(1<<LCD_E)		;E=0
				out LCD_Port,r18

				ret


LCD_Command:	in r18,LCD_Port

				cbr r18,(1<<LCD_RS | 1<<LCD_RW)	;RS=0, RW=0

				rcall LCD_Send_DH

				swap r16
				rcall LCD_Send_DH

				ret


LCD_Data:		in r18,LCD_Port

				sbr r18,(1<<LCD_RS)		;RS=1
				cbr r18,(1<<LCD_RW)		;RW=0

				rcall LCD_Send_DH

				swap r16
				rcall LCD_Send_DH

				ret


LCD_Read:		in r17,DDRC
				cbr r17,0xF0				;make data lines inputs
				out DDRC,r17

				in r18,LCD_Port

				cbr r18,0xF0				;clear data lines (will turn pullups off)
				sbr r18,(1<<LCD_RS | 1<<LCD_RW | 1<<LCD_E)	;RS=1, RW=1, E=1

				out LCD_Port,r18
				rcall LCD_Delay_1
				cbr r18,(1<<LCD_E)		;E=0
				out LCD_Port,r18

				nop

				in r16,PINC					;get high nibble
				
				sbr r18,(1<<LCD_E)
				out LCD_Port,r18
				rcall LCD_Delay_1
				cbr r18,(1<<LCD_E)
				out LCD_Port,r18
				
				nop
				
				in r17,PINC					;get low nibble
				
				cbr r16,0x0F
				cbr r17,0x0F
				swap r17
				or r16,r17					;r16 = read data
				
				ldi r17,0b11111111			;PORTC<7:0> = output
				out DDRC,r17

				ret





LCD_Init:		;Initialise LCD

				rcall LCD_Delay_4100
				rcall LCD_Delay_4100
				rcall LCD_Delay_4100
				rcall LCD_Delay_4100	;16.4ms delay after powerup

				in r18,LCD_Port

				cbr r18,exp2(LCD_RS)	;RS=0
				cbr r18,exp2(LCD_RW)	;RW=0
				
				ldi r16,0x30			;data=3
				rcall LCD_Send_DH

				rcall LCD_Delay_4100	;4.1ms delay
				
				rcall LCD_Send_DH

				rcall LCD_Delay_160		;160us delay

				rcall LCD_Send_DH

				rcall LCD_Delay_160		;160us delay

				ldi r16,0x20			;data=2
				rcall LCD_Send_DH

				rcall LCD_Delay_160		;160us delay

				ldi r16,0x28
				rcall LCD_Command
				rcall LCD_Delay_160

				ldi r16,0x06
				rcall LCD_Command
				rcall LCD_Delay_160

				ldi r16,0x0C
				rcall LCD_Command
				rcall LCD_Delay_160

				ldi r16,0x01
				rcall LCD_Command
				rcall LCD_Delay_4100

				ldi r16,0x80
				rcall LCD_Command
				rcall LCD_Delay_160

				ret


LCD_SMsg:		;Send Start Message From Eeprom

				ldi r24,low(EE_Start_Msg_0)
				ldi r25,high(EE_Start_Msg_0)	;Get EEPROM Start Adr.

				ldi r23,80				;Set Counter

				Set_FIFO_Address LCD_FIFO	;Set FIFO pointer

LCD_SMsg_A:		out EEARL,r24
				out EEARH,r25
				
				sbi EECR,EERE
				
				in r16,EEDR				;Get byte
				
				call FIFO_Write			;Send to LCD FIFO
				
				adiw r25:r24,1			;Inc Address

				dec r23					;Dec counter

				brne LCD_SMsg_A
								
				ret


LCD0_Routine:
		Set_FIFO_Address LCD_FIFO
		ld r16,Z				;Get LCD FIFO counter value
		cpi r16,0x00
		brne LCD0_Routine_A		;Start LCD0 routine if counter>0

		;FIFO counter=0
		clr LCD_C0				;LCD0 counter = 0
		
		ret						;exit LCD0 routine


LCD0_Routine_A:
		call FIFO_Read			;r16 = next byte in FIFO

		lds ZL,LCD0_Routine_Jump_Adr
		lds ZH,(LCD0_Routine_Jump_Adr+1)
		ijmp					;jump to relevant LCD0_Routine section

LCD0_Routine_Default:
		cpi r16,LCDC
		brne LCD0_Routine_Default_A	;test for LCD command pointer

		;LCD command pointer found
		ldi r16,low(LCD0_Routine_Command)
		ldi r17,high(LCD0_Routine_Command)

		sts LCD0_Routine_Jump_Adr,r16
		sts (LCD0_Routine_Jump_Adr+1),r17	;Set jump address

		clr LCD_C0				;LCD0 counter = 0

		mov r16,DC1_B0
		cbr r16,(1<<R_W)
		mov DC1_B0,r16			;turn RW off

		ret

LCD0_Routine_Default_A:
		sbrc DC1_B0,R_W
		rjmp LCD0_Routine_Default_Read

		;write data
		ldi r17,5
		mov LCD_C0,r17			;LCD0 counter = 160us

		call LCD_Data

		ret


LCD0_Routine_Default_Read:
		ldi r17,5
		mov LCD_C0,r17			;LCD0 counter = 160 us

		Set_FIFO_Address USART_RX_FIFO
		
		ldi r16,DC1				;Send DC1
		call FIFO_Write

		call LCD_Read			;Send read byte
		call FIFO_Write

		ldi r16,ETB				;Send ETB
		call FIFO_Write

		ret

LCD0_Routine_Command:
		ldi r17,low(LCD0_Routine_Default)
		ldi r18,high(LCD0_Routine_Default)

		sts LCD0_Routine_Jump_Adr,r17
		sts (LCD0_Routine_Jump_Adr+1),r18	;Set jump address
		
		ldi r17,5

		cpi r16,0x08
		brsh LCD0_Routine_Command_A		;Check delay period required

		;4.1ms delay required
		ldi r17,128
		
LCD0_Routine_Command_A:
		
		;160us delay required
		mov LCD_C0,r17				;LCD0 Counter = 32*r17

		call LCD_Command

		ret



LCD1_Routine:
		lds ZL,LCD1_Routine_Jump_Adr
		lds ZH,(LCD1_Routine_Jump_Adr+1)
		ijmp						;Jump to relevant LCD 1 section


LCD1_Routine_Init_Delay:

		lds r16,LCD1_Routine_Counter

		tst r16
		breq LCD1_Routine_Init_Delay_A

		;counter != 0

		dec r16
		sts LCD1_Routine_Counter,r16	;decrease counter

		ldi r16,low(31250)
		ldi r17,high(31250)

		mov LCD_C1L,r16
		mov LCD_C1H,r17			;LCD1 counter = 1s

		ret

LCD1_Routine_Init_Delay_A:

		;counter = 0

		mov r16,DC1_B0
		cbr r16,(1<<SAS | 1<<SDS | 1<<SSP | 1<<VDM | 1<<R_W | 1<<BKL)

		cpi r16,0
		brne LCD1_Routine_Init_Delay_B

		;VD = 00
		mov r16,Ticker_Flags
		cbr r16,(1<<Update_LCD1 | 1<<Test_LCD1)
		mov Ticker_Flags,r16		;Stop further LCD1 tests

		sbrc DC1_B0,SSP
		ret							;SSP = 0

		;SSP = 1
		Set_FIFO_Address LCD_FIFO

		ldi r16,254
		call FIFO_Write

		ldi r16,0b00000001
		call FIFO_Write				;Write "Clear Display" command to LCD

		ret


LCD1_Routine_Init_Delay_B:
		
		;VD != 00
		cpi r16,(1<<VD0)
		brne LCD1_Routine_Init_Delay_C

		;VD = 01
		rcall LCD1_Routine_Disp_PWM
		rjmp LCD1_Routine_Init_Delay_D

LCD1_Routine_Init_Delay_C:
		;VD = 10 or 11
		rcall LCD1_Routine_Disp_ADC


LCD1_Routine_Init_Delay_D:
		ldi r16,low(15625)
		ldi r17,high(15625)

		mov LCD_C1L,r16
		mov LCD_C1H,r17			;LCD1 counter = 0.5s

		ldi r16,9
		sts	LCD1_Routine_Counter,r16	;Routine counter = 9 (~5s)	

		ldi r16,low(LCD1_Routine_VD)
		ldi r17,high(LCD1_Routine_VD)

		sts LCD1_Routine_Jump_Adr,r16
		sts (LCD1_Routine_Jump_Adr+1),r17	;Set jump address

		ret

LCD1_Routine_VD:
		ldi r16,low(15625)
		ldi r17,high(15625)

		mov LCD_C1L,r16
		mov LCD_C1H,r17			;LCD1 counter = 0.5s

		mov r16,DC1_B0
		cbr r16,(1<<SAS | 1<<SDS | 1<<SSP | 1<<VDM | 1<<R_W | 1<<BKL)

		cpi r16,(1<<VD0)
		brne LCD1_Routine_VD_A

		;VD=01
		rcall LCD1_Routine_Disp_PWM

		ret


LCD1_Routine_VD_A:

		cpi r16,(1<<VD1)
		brne LCD1_Routine_VD_B

		;VD=10
		rcall LCD1_Routine_Disp_ADC

		ret


LCD1_Routine_VD_B:
		;VD=11
		lds r16,LCD1_Routine_Flags

		sbrs r16,Disp_ADC
		rcall LCD1_Routine_Disp_PWM

		sbrc r16,Disp_ADC
		rcall LCD1_Routine_Disp_ADC

		lds r16,LCD1_Routine_Counter

		dec r16
		breq LCD1_Routine_VD_C

		sts LCD1_Routine_Counter,r16
		ret

LCD1_Routine_VD_C:
		ldi r16,9
		sts LCD1_Routine_Counter,r16

		lds r16,LCD1_Routine_Flags

		sbrs r16,Disp_ADC
		rjmp LCD1_Routine_VD_D

		cbr r16,(1<<Disp_ADC)
		sts LCD1_Routine_Flags,r16

		ret

LCD1_Routine_VD_D:
		sbr r16,(1<<Disp_ADC)
		sts LCD1_Routine_Flags,r16

		ret


LCD1_Routine_Disp_ADC:

		sbrc DC1_B0,VDM
		rjmp LCD1_Routine_Disp_ADC_A

		;Get ADC values and convert to ASCII
		lds r16,ADC0_Val+1			;get ADC0 val (MSB only)
		clr r17

		call bin2BCD16				;convert to BCD

		call BCD16_ASCII_Spc		;convert to ASCII

		ldi XL,low(LCD1_BCD_0)
		ldi XH,high(LCD1_BCD_0)
		st X+,r16					;store
		st X+,r17
		st X+,r18

		lds r16,ADC1_Val+1			;get ADC1 val (MSB only)
		clr r17

		call bin2BCD16				;convert to BCD

		call BCD16_ASCII_Spc		;convert to ASCII

		ldi XL,low(LCD1_BCD_1)
		ldi XH,high(LCD1_BCD_1)
		st X+,r16					;store
		st X+,r17
		st X+,r18

		lds r16,ADC2_Val+1			;get ADC2 val (MSB only)
		clr r17

		call bin2BCD16				;convert to BCD

		call BCD16_ASCII_Spc		;convert to ASCII

		ldi XL,low(LCD1_BCD_2)
		ldi XH,high(LCD1_BCD_2)
		st X+,r16					;store
		st X+,r17
		st X+,r18

		lds r16,ADC3_Val+1			;get ADC3 val (MSB only)
		clr r17

		call bin2BCD16				;convert to BCD

		call BCD16_ASCII_Spc		;convert to ASCII

		ldi XL,low(LCD1_BCD_3)
		ldi XH,high(LCD1_BCD_3)
		st X+,r16					;store
		st X+,r17
		st X+,r18

		rjmp LCD1_Routine_Disp_ADC_B

LCD1_Routine_Disp_ADC_A:
		;bargraph generation

		lds r16,ADC0_Val+1			;get ADC_0 value (MSB)

		ldi XL,low(LCD1_BCD_0)
		ldi XH,high(LCD1_BCD_0)

		call LCD_Bargraph_Gen

		lds r16,ADC1_Val+1			;get ADC_1 value (MSB)

		ldi XL,low(LCD1_BCD_1)
		ldi XH,high(LCD1_BCD_1)

		call LCD_Bargraph_Gen

		lds r16,ADC2_Val+1			;get ADC_2 value (MSB)

		ldi XL,low(LCD1_BCD_2)
		ldi XH,high(LCD1_BCD_2)

		call LCD_Bargraph_Gen

		lds r16,ADC3_Val+1			;get ADC_3 value (MSB)

		ldi XL,low(LCD1_BCD_3)
		ldi XH,high(LCD1_BCD_3)

		call LCD_Bargraph_Gen


LCD1_Routine_Disp_ADC_B:
		Set_FIFO_Address LCD_FIFO

		ldi r16,254
		call FIFO_Write

		ldi r16,0x80
		call FIFO_Write				;Adr = 0

		;ADC0 line
		ldi XL,low(ADC0_Name)
		ldi XH,high(ADC0_Name)

		rcall LCD1_Routine_Send_Name

		ldi r16,LCD_Separator
		call FIFO_Write				;Write separator character

		ldi XL,low(LCD1_BCD_0)
		ldi XH,high(LCD1_BCD_0)

		sbrc DC1_B0,VDM
		rcall LCD1_Routine_Send_Bargraph

		sbrs DC1_B0,VDM
		rcall LCD1_Routine_Send_BCD

		;ADC2 line
		ldi XL,low(ADC2_Name)
		ldi XH,high(ADC2_Name)

		rcall LCD1_Routine_Send_Name

		ldi r16,LCD_Separator
		call FIFO_Write				;Write separator character

		ldi XL,low(LCD1_BCD_2)
		ldi XH,high(LCD1_BCD_2)

		sbrc DC1_B0,VDM
		rcall LCD1_Routine_Send_Bargraph

		sbrs DC1_B0,VDM
		rcall LCD1_Routine_Send_BCD

		;ADC1 line
		ldi XL,low(ADC1_Name)
		ldi XH,high(ADC1_Name)

		rcall LCD1_Routine_Send_Name

		ldi r16,LCD_Separator
		call FIFO_Write				;Write separator character

		ldi XL,low(LCD1_BCD_1)
		ldi XH,high(LCD1_BCD_1)

		sbrc DC1_B0,VDM
		rcall LCD1_Routine_Send_Bargraph

		sbrs DC1_B0,VDM
		rcall LCD1_Routine_Send_BCD

		;ADC3 line
		ldi XL,low(ADC3_Name)
		ldi XH,high(ADC3_Name)

		rcall LCD1_Routine_Send_Name

		ldi r16,LCD_Separator
		call FIFO_Write				;Write separator character

		ldi XL,low(LCD1_BCD_3)
		ldi XH,high(LCD1_BCD_3)

		sbrc DC1_B0,VDM
		rcall LCD1_Routine_Send_Bargraph

		sbrs DC1_B0,VDM
		rcall LCD1_Routine_Send_BCD

		ret


LCD1_Routine_Disp_PWM:
		sbrc DC1_B0,VDM
		rjmp LCD1_Routine_Disp_PWM_A

		;Get PWM values and convert to ASCII
		in r16,OCR0					;get PWM0 val (MSB only)
		clr r17

		call bin2BCD16				;convert to BCD

		call BCD16_ASCII_Spc		;convert to ASCII

		ldi XL,low(LCD1_BCD_0)
		ldi XH,high(LCD1_BCD_0)
		st X+,r16					;store
		st X+,r17
		st X+,r18

		in r16,OCR1AL				;get PWM1 val (MSB only)
		clr r17

		call bin2BCD16				;convert to BCD

		call BCD16_ASCII_Spc		;convert to ASCII

		ldi XL,low(LCD1_BCD_1)
		ldi XH,high(LCD1_BCD_1)
		st X+,r16					;store
		st X+,r17
		st X+,r18

		in r16,OCR1BL				;get PWM2 val (MSB only)
		clr r17

		call bin2BCD16				;convert to BCD

		call BCD16_ASCII_Spc		;convert to ASCII

		ldi XL,low(LCD1_BCD_2)
		ldi XH,high(LCD1_BCD_2)
		st X+,r16					;store
		st X+,r17
		st X+,r18

		in r16,OCR2					;get PWM3 val (MSB only)
		clr r17

		call bin2BCD16				;convert to BCD

		call BCD16_ASCII_Spc		;convert to ASCII

		ldi XL,low(LCD1_BCD_3)
		ldi XH,high(LCD1_BCD_3)
		st X+,r16					;store
		st X+,r17
		st X+,r18

		rjmp LCD1_Routine_Disp_PWM_B

LCD1_Routine_Disp_PWM_A:
		;bargraph generation

		in r16,OCR0					;get PWM_0 value (MSB)

		ldi XL,low(LCD1_BCD_0)
		ldi XH,high(LCD1_BCD_0)

		call LCD_Bargraph_Gen

		in r16,OCR1AL				;get PWM_1 value (MSB)

		ldi XL,low(LCD1_BCD_1)
		ldi XH,high(LCD1_BCD_1)

		call LCD_Bargraph_Gen

		in r16,OCR1BL				;get PWM_2 value (MSB)

		ldi XL,low(LCD1_BCD_2)
		ldi XH,high(LCD1_BCD_2)

		call LCD_Bargraph_Gen

		in r16,OCR2					;get PWM_3 value (MSB)

		ldi XL,low(LCD1_BCD_3)
		ldi XH,high(LCD1_BCD_3)

		call LCD_Bargraph_Gen


LCD1_Routine_Disp_PWM_B:
		Set_FIFO_Address LCD_FIFO

		ldi r16,254
		call FIFO_Write

		ldi r16,0x80
		call FIFO_Write				;Adr = 0

		;PWM0 line
		ldi XL,low(PWM0_Name)
		ldi XH,high(PWM0_Name)

		rcall LCD1_Routine_Send_Name

		ldi r16,LCD_Separator
		call FIFO_Write				;Write separator character

		ldi XL,low(LCD1_BCD_0)
		ldi XH,high(LCD1_BCD_0)

		sbrc DC1_B0,VDM
		rcall LCD1_Routine_Send_Bargraph

		sbrs DC1_B0,VDM
		rcall LCD1_Routine_Send_BCD

		;PWM2 line
		ldi XL,low(PWM2_Name)
		ldi XH,high(PWM2_Name)

		rcall LCD1_Routine_Send_Name

		ldi r16,LCD_Separator
		call FIFO_Write				;Write separator character

		ldi XL,low(LCD1_BCD_2)
		ldi XH,high(LCD1_BCD_2)

		sbrc DC1_B0,VDM
		rcall LCD1_Routine_Send_Bargraph

		sbrs DC1_B0,VDM
		rcall LCD1_Routine_Send_BCD

		;PWM1 line
		ldi XL,low(PWM1_Name)
		ldi XH,high(PWM1_Name)

		rcall LCD1_Routine_Send_Name

		ldi r16,LCD_Separator
		call FIFO_Write				;Write separator character

		ldi XL,low(LCD1_BCD_1)
		ldi XH,high(LCD1_BCD_1)

		sbrc DC1_B0,VDM
		rcall LCD1_Routine_Send_Bargraph

		sbrs DC1_B0,VDM
		rcall LCD1_Routine_Send_BCD

		;PWM3 line
		ldi XL,low(PWM3_Name)
		ldi XH,high(PWM3_Name)

		rcall LCD1_Routine_Send_Name

		ldi r16,LCD_Separator
		call FIFO_Write				;Write separator character

		ldi XL,low(LCD1_BCD_3)
		ldi XH,high(LCD1_BCD_3)

		sbrc DC1_B0,VDM
		rcall LCD1_Routine_Send_Bargraph

		sbrs DC1_B0,VDM
		rcall LCD1_Routine_Send_BCD

		ret



LCD1_Routine_Send_Name:

		ld r19,X+					;r19 = character count

		ldi r20,10					;total count

LCD1_Routine_Send_Name_A:
		ldi r16,' '

		cpi r19,1
		brlt LCD1_Routine_Send_Name_B

		ld r16,X+					;get character

LCD1_Routine_Send_Name_B:
		call FIFO_Write				;send character

		dec r19
		dec r20						;decrease counters

		brne LCD1_Routine_Send_Name_A

		ret

LCD1_Routine_Send_Bargraph:
		adiw XH:XL,8

		ldi r19,8

LCD1_Routine_Send_Bargraph_A:
		ld r16,-X
		call FIFO_Write

		dec r19

		brne LCD1_Routine_Send_Bargraph_A

		ldi r16,' '
		call FIFO_Write

		ret

LCD1_Routine_Send_BCD:
		adiw XH:XL,3

		ld r16,-X
		call FIFO_Write

		ld r16,-X
		call FIFO_Write

		ld r16,-X
		call FIFO_Write

		ldi r19,6
		ldi r16,' '

LCD1_Routine_Send_BCD_A:
		call FIFO_Write

		dec r19

		brne LCD1_Routine_Send_BCD_A

		ret

		
BCD16_ASCII:
		;Convert 16 bit BCD number (r20:r18) into ASCII.
		;Result is placed in r20:r16.

		mov r16,r18
		mov r17,r19			;store BCD values that may be overwritten

		cbr r20,0xF0
		subi r20,-48		;r20 = digit 4

		swap r19
		cbr r19,0xF0
		subi r19,-48		;r19 = digit 3

		mov r18,r17
		cbr r18, 0xF0
		subi r18,-48		;r18 = digit 2

		mov r17,r16
		swap r17
		cbr r17,0xF0
		subi r17,-48		;r17 = digit 1

		cbr r16,0xF0
		subi r16,-48		;r16 = digit 0

		ret

BCD16_ASCII_Spc:

		;BCD16 to ascii. Leading zeros are spaces

		rcall BCD16_ASCII

		cpi r20,48
		breq BCD16_ASCII_Spc_A

		ret

BCD16_ASCII_Spc_A:

		ldi r20,' '

		cpi r19,48
		breq BCD16_ASCII_Spc_B

		ret

BCD16_ASCII_Spc_B:

		ldi r19,' '

		cpi r18,48
		breq BCD16_ASCII_Spc_C

		ret

BCD16_ASCII_Spc_C:

		ldi r18,' '

		cpi r17,48
		breq BCD16_ASCII_Spc_D

		ret

BCD16_ASCII_Spc_D:

		ldi r17,' '

		ret

LCD_Bargraph_Gen:
		ldi r17,8
		ldi r18,LCD_Bar_Off

LCD_Bargraph_Gen_A:
		st X+,r18

		dec r17

		brne LCD_Bargraph_Gen_A

		ldi r18,LCD_Bar_On
		ldi r17,7

		subi r16,31
		brsh LCD_Bargraph_Gen_B

		ret

LCD_Bargraph_Gen_B:
		st -X,r18

LCD_Bargraph_Gen_C:
		subi r16,32
		brsh LCD_Bargraph_Gen_D

		ret

LCD_Bargraph_Gen_D:
		st -X,r18

		dec r17

		brne LCD_Bargraph_Gen_C

		ret







				







				